import gulp from 'gulp'
import { registerTasks } from '@creative-themes/build-process'
import removeCode from 'gulp-remove-code'
import { execSync } from 'child_process'
import glob from 'glob'

import data from './package.json' with { type: 'json' }

const wpExternals = {
	'@wordpress/element': 'window.wp.element',
	'@wordpress/editor': 'window.wp.editor',
	'@wordpress/is-shallow-equal': 'window.wp.isShallowEqual',
	'@wordpress/media-utils': 'window.wp.mediaUtils',
	'@wordpress/keyboard-shortcuts': 'window.wp.keyboardShortcuts',
	'@wordpress/core-data': 'window.wp.coreData',
	'@wordpress/block-editor': 'window.wp.blockEditor',
	'@wordpress/blocks': 'window.wp.blocks',
	'@wordpress/primitives': 'window.wp.primitives',
	'@wordpress/hooks': 'window.wp.hooks',
	'@wordpress/components': 'window.wp.components',
	'@wordpress/date': 'window.wp.date',
	'@wordpress/edit-post': 'window.wp.editPost',
	'@wordpress/plugins': 'window.wp.plugins',
	'@wordpress/data': 'window.wp.data',
	'@wordpress/compose': 'window.wp.compose',
	'@wordpress/keycodes': 'window.wp.keycodes',
	'@wordpress/api-fetch': 'window.wp.apiFetch',
	'@wordpress/widgets': 'window.wp.widgets',
	'@wordpress/block-library': 'window.wp.blockLibrary',
	'@wordpress/url': 'window.wp.url',
	'@wordpress/private-apis': 'window.wp.privateApis',
	'@wordpress/a11y': 'window.wp.a11y',
	'blocksy-options': 'window.blocksyOptions',
	react: 'React',
	'react-dom': 'ReactDOM',
}

var options = {
	packageType: 'wordpress_theme',
	packageSlug: 'blocksy',
	packageI18nSlug: 'blocksy',

	entries: [
		{
			entry: './static/js/main.js',
			output: {
				library: 'ctFrontend',
				libraryTarget: 'global',

				chunkLoadingGlobal: 'blocksyJsonP',
				path: './static/bundle/',
				chunkFilename: '[id].[chunkhash].js',
				publicPath: '',
			},

			hasStatsOutput: true,

			/*
			optimization: {
				splitChunks: {
					cacheGroups: {
						default: false,
						vendors: false,

						popper: {
							chunks: 'all',
							test: /popper/,
						},
					},
				},
			},
			*/
		},

		{
			entry: './static/js/events.js',
			output: {
				filename: 'events.js',
				path: './static/bundle/',
				chunkFilename: '[id].[chunkhash].js',

				library: 'ctEvents',
			},
		},

		{
			entry: './static/js/options.js',
			output: {
				filename: 'options.js',
				path: './static/bundle/',
				chunkFilename: '[id].[chunkhash].js',
				chunkLoadingGlobal: 'blocksyJsonP',
				library: 'blocksyOptions',
			},

			externals: {
				_: 'window._',
				jquery: 'jQuery',
				'ct-i18n': 'window.wp.i18n',
				'ct-events': 'ctEvents',
				underscore: 'window._',
				...wpExternals,
			},
		},

		{
			entry: './static/js/customizer/sync.js',
			output: {
				filename: 'sync.min.js',
				path: './static/bundle/',
				chunkLoadingGlobal: 'blocksyJsonP',
				library: 'blocksyCustomizerSync',
			},
			externals: {
				_: 'window._',
				jquery: 'jQuery',
				'ct-i18n': 'window.wp.i18n',
				'ct-events': 'window.ctEvents',
				underscore: 'window._',
				...wpExternals,
			},
		},

		{
			entry: './static/js/editor.js',
			output: {
				filename: 'editor.js',
				path: './static/bundle/',
				chunkLoadingGlobal: 'blocksyEditorJsonP',
			},
			externals: {
				_: 'window._',
				jquery: 'jQuery',
				'ct-i18n': 'window.wp.i18n',
				'ct-events': 'ctEvents',
				underscore: 'window._',
				...wpExternals,
			},
		},

		{
			entry: './static/js/customizer/controls.js',
			output: {
				filename: 'customizer-controls.js',
				path: './static/bundle/',
				chunkLoadingGlobal: 'blocksyJsonP',
				chunkFilename: '[id].[chunkhash].js',
				library: 'blocksyOptions',
			},
			externals: {
				_: 'window._',
				jquery: 'jQuery',
				'ct-i18n': 'window.wp.i18n',
				'ct-events': 'ctEvents',
				underscore: 'window._',
				...wpExternals,
			},
		},

		{
			entry: './admin/dashboard/static/js/main.js',
			output: {
				path: './admin/dashboard/static/bundle',
				chunkLoadingGlobal: 'blocksyJsonP',
			},
			externals: {
				jquery: 'jQuery',
				'ct-i18n': 'window.wp.i18n',
				'ct-events': 'ctEvents',
				underscore: 'window._',
				...wpExternals,
			},
		},
	],

	sassFiles: [
		{
			input: 'static/sass/frontend/main.scss',
			output: 'static/bundle',
			filename: 'main.min',
		},

		{
			input: 'static/sass/frontend/5-modules/page-title/main.scss',
			output: 'static/bundle',
			filename: 'page-title.min',
		},

		{
			input: 'static/sass/frontend/4-components/back-to-top.scss',
			output: 'static/bundle',
			filename: 'back-to-top.min',
		},

		{
			input: 'static/sass/frontend/5-modules/blocks/non-critical-search-styles.scss',
			output: 'static/bundle',
			filename: 'non-critical-search-styles.min',
		},

		{
			input: 'static/sass/frontend/5-modules/blocks/about-me.scss',
			output: 'static/bundle',
			filename: 'theme-block-about-me.min',
		},

		{
			input: 'static/sass/frontend/5-modules/blocks/share-box.scss',
			output: 'static/bundle',
			filename: 'theme-block-share-box.min',
		},

		{
			input: 'static/sass/frontend/admin-frontend.scss',
			output: 'static/bundle',
			filename: 'admin-frontend.min',
		},

		{
			input: 'static/sass/frontend/3-actions/no-scripts.scss',
			output: 'static/bundle',
			filename: 'no-scripts.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/forminator/main.scss',
			output: 'static/bundle',
			filename: 'forminator.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/jet-woo-builder.scss',
			output: 'static/bundle',
			filename: 'jet-woo-builder.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/tribe-events.scss',
			output: 'static/bundle',
			filename: 'tribe-events.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/getwid.scss',
			output: 'static/bundle',
			filename: 'getwid.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/brizy.scss',
			output: 'static/bundle',
			filename: 'brizy.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/beaver.scss',
			output: 'static/bundle',
			filename: 'beaver.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/divi.scss',
			output: 'static/bundle',
			filename: 'divi.min',
		},

		// {
		// 	input: 'static/sass/frontend/8-integrations/vc.scss',
		// 	output: 'static/bundle',
		// 	filename: 'vc.min',
		// },

		{
			input: 'static/sass/frontend/8-integrations/cf-7.scss',
			output: 'static/bundle',
			filename: 'cf-7.min',
		},

		// {
		// 	input: 'static/sass/frontend/8-integrations/fluent-form.scss',
		// 	output: 'static/bundle',
		// 	filename: 'fluent-form.min',
		// },

		{
			input: 'static/sass/frontend/8-integrations/stackable.scss',
			output: 'static/bundle',
			filename: 'stackable.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/qubely.scss',
			output: 'static/bundle',
			filename: 'qubely.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/bbpress.scss',
			output: 'static/bundle',
			filename: 'bbpress.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/buddypress.scss',
			output: 'static/bundle',
			filename: 'buddypress.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/wpforms.scss',
			output: 'static/bundle',
			filename: 'wpforms.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/dokan.scss',
			output: 'static/bundle',
			filename: 'dokan.min',
		},

		{
			input: 'static/sass/frontend/non-critical-styles.scss',
			output: 'static/bundle',
			filename: 'non-critical-styles.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/elementor.scss',
			output: 'static/bundle',
			filename: 'elementor-frontend.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/woocommerce/integrations/elementor.scss',
			output: 'static/bundle',
			filename: 'elementor-woocommerce-frontend.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/tutor/main.scss',
			output: 'static/bundle',
			filename: 'tutor.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/woocommerce/main.scss',
			output: 'static/bundle',
			filename: 'woocommerce.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/woocommerce/cart-header-element-lazy.scss',
			output: 'static/bundle',
			filename: 'cart-header-element-lazy.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/woocommerce/blocks/main-cart-checkout-blocks.scss',
			output: 'static/bundle',
			filename: 'woocommerce-cart-checkout-blocks.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/page-scroll-to-id.scss',
			output: 'static/bundle',
			filename: 'page-scroll-to-id.min',
		},

		{
			input: 'static/sass/frontend/8-integrations/eventkoi.scss',
			output: 'static/bundle',
			filename: 'eventkoi.min',
		},

		{
			input: 'static/sass/frontend/6-layout/sidebar/main.scss',
			output: 'static/bundle',
			filename: 'sidebar.min',
		},

		{
			input: 'static/sass/frontend/5-modules/share-box/main.scss',
			output: 'static/bundle',
			filename: 'share-box.min',
		},

		{
			input: 'static/sass/frontend/4-components/flexy.scss',
			output: 'static/bundle',
			filename: 'flexy.min',
		},

		{
			input: 'static/sass/frontend/5-modules/comments.scss',
			output: 'static/bundle',
			filename: 'comments.min',
		},

		{
			input: 'static/sass/frontend/4-components/author-box.scss',
			output: 'static/bundle',
			filename: 'author-box.min',
		},

		{
			input: 'static/sass/frontend/4-components/posts-nav.scss',
			output: 'static/bundle',
			filename: 'posts-nav.min',
		},

		{
			input: 'static/sass/frontend/4-components/pagination.scss',
			output: 'static/bundle',
			filename: 'pagination.min',
		},

		{
			input: 'static/sass/frontend/6-layout/entries/main.scss',
			output: 'static/bundle',
			filename: 'entries.min',
		},

		{
			input: 'static/sass/frontend/4-components/featured-image.scss',
			output: 'static/bundle',
			filename: 'featured-image.min',
		},

		{
			input: 'static/sass/frontend/4-components/related-posts.scss',
			output: 'static/bundle',
			filename: 'related-posts.min',
		},

		{
			input: 'static/sass/backend/editor/main.scss',
			output: 'static/bundle',
			filename: 'editor.min',
		},

		{
			input: 'static/sass/backend/editor/iframe.scss',
			output: 'static/bundle',
			filename: 'editor-iframe.min',
		},

		{
			input: 'static/sass/backend/editor/blocks/main.scss',
			output: 'static/bundle',
			filename: 'editor-styles.min',
		},
		{
			input: 'static/sass/backend/editor/blocks/theme-blocks.scss',
			output: 'static/bundle',
			filename: 'theme-blocks-editor-styles.min',
		},

		{
			input: 'static/sass/backend/customizer/main.scss',
			output: 'static/bundle',
			filename: 'customizer-controls.min',
		},

		{
			input: 'static/sass/backend/admin.scss',
			output: 'static/bundle',
			filename: 'options.min',
		},

		{
			input: 'admin/dashboard/static/sass/main.scss',
			output: 'admin/dashboard/static/bundle',
			filename: 'main.min',
		},

		// rtl
		{
			input: 'static/sass/frontend/main-rtl.scss',
			output: 'static/bundle',
			filename: 'main-rtl.min',
		},

		{
			input: 'static/sass/backend/editor/main-rtl.scss',
			output: 'static/bundle',
			filename: 'editor-rtl.min',
		},

		{
			input: 'static/sass/backend/customizer/main-rtl.scss',
			output: 'static/bundle',
			filename: 'customizer-controls-rtl.min',
		},

		{
			input: 'static/sass/backend/admin-rtl.scss',
			output: 'static/bundle',
			filename: 'options-rtl.min',
		},

		{
			input: 'admin/dashboard/static/sass/main-rtl.scss',
			output: 'admin/dashboard/static/bundle',
			filename: 'main-rtl.min',
		},
	],

	sassWatch: [
		'static/sass/**/*.scss',
		'admin/dashboard/static/sass/**/*.scss',
	],

	webpackDevtool: 'source-map',
	webpackExternals: {
		jquery: 'jQuery',
		'ct-i18n': 'window.wp.i18n',
		'ct-events': 'ctEvents',
		underscore: 'window._',
		'@wordpress/element': 'window.wp.element',
		'@wordpress/primitives': 'window.wp.primitives',
		'@wordpress/hooks': 'window.wp.hooks',
		'@wordpress/date': 'window.wp.date',
	},

	commonWebpackFields: {},

	webpackPlugins: [],

	webpackResolveAliases: {},

	babelAdditionalPlugins: [
		'babel-plugin-lodash',
		'@babel/plugin-transform-parameters',
	],

	modulesToCompileWithBabel: [
		'@wordpress/element',
		'@creative-themes/flexy',
		'@wordpress/components',
		'@creative-themes/wordpress-helpers',
	],

	filesToDeleteFromBuild: [
		'./build_tmp/build/Blocksy.code-workspace',
		'./build_tmp/build/tags',
		'./build_tmp/build/node_modules/',
		'./build_tmp/build/phpcs.xml.dist',
		'./build_tmp/build/child-theme/',
		'./build_tmp/build/composer.json',
		'./build_tmp/build/yarn.lock',
		'./build_tmp/build/package-lock.json',
		'./build_tmp/build/wp-cli.yml',
		'./build_tmp/build/.babelrc',
		'./build_tmp/build/docs',
		'./build_tmp/build/CLAUDE.md',
		'./build_tmp/build/extensions.json',
		// './build_tmp/build/gulpfile.js',
		// './build_tmp/build/gulpfile.mjs',
		// './build_tmp/build/package.json',
		'./build_tmp/build/psds',
		'./build_tmp/build/ruleset.xml',
		'./build_tmp/build/tests',
		'./build_tmp/build/scripts',
		'./build_tmp/build/inc/sass-live-sync.php',
		'./build_tmp/build/sass-live-sync.js',

		'./build_tmp/build/composer.lock',
		'./build_tmp/build/composer.json',
		'./build_tmp/build/phpunit.xml.dist',
		'./build_tmp/build/tests',

		// './build_tmp/build/admin/dashboard/static/{js,sass}',
		// './build_tmp/build/static/{js,sass}'
		],

	toClean: ['static/bundle/', 'admin/dashboard/static/bundle/'],

	babelJsxPlugin: 'react',
	babelJsxReactPragma: 'createElement',
}

registerTasks(gulp, options)

gulp.task('gettext-generate-js', (done) => {
	try {
		execSync('npx gulp build', {
			stdio: 'inherit',

			env: {
				...process.env,
				NODE_ENV_GETTEXT: 'true',
				NODE_ENV: 'production',
			},
		})
	} catch (error) {
		console.warn('Warning: gettext-generate-js failed:', error.message)
	}
	done()
})

gulp.task(
	'gettext-generate',
	gulp.series('gettext-generate-js', 'gettext-generate:php', (done) => {
		try {
			execSync(
				"msgcat languages/blocksy-php.pot languages/ct-js.pot | grep -v '#-#-#-#' > ./languages/blocksy.pot && rm ./languages/blocksy-php.pot ./languages/ct-js.pot",
				{ stdio: 'inherit', shell: '/bin/bash' }
			)
		} catch (error) {
			console.warn('Warning: msgcat merge failed:', error.message)
		}
		done()
	})
)
